# IceHrm Pro - v35

**Release Date:** December 2026
**Version:** 35.0.0

We're excited to announce a major update to IceHrm Pro with significant new features, UI enhancements, and improvements across multiple modules. This release focuses on providing better insights, streamlined workflows, and a more modern user experience.

---

## Table of Contents

1. [New Insights & Analytics Module](#new-insights--analytics-module)
2. [Redesigned Payroll Configuration Module](#redesigned-payroll-configuration-module)
3. [Enhanced Travel Management](#enhanced-travel-management)
4. [Project Time Tracking](#project-time-tracking)
5. [Employee Profile Enhancements](#employee-profile-enhancements)
6. [Performance Management Improvements](#performance-management-improvements)
7. [Sandwich Leave Support](#sandwich-leave-support)
8. [Settings Module Redesign](#settings-module-redesign)
9. [UI/UX Improvements](#uiux-improvements)
10. [Bug Fixes](#bug-fixes)

---

## New Insights & Analytics Module

A brand new **Insights** module provides comprehensive analytics dashboards for leave, attendance, and timesheet data, giving HR managers and administrators real-time visibility into workforce patterns.

### Leave Insights

Get a complete overview of leave patterns across your organization:

- **Leave Summary Dashboard** - View approved, pending, and rejected leave requests at a glance
- **Monthly Leave Distribution** - Visualize leave patterns across months to identify trends
- **Weekly Leave Patterns** - Understand which days of the week see the most leave requests
- **Leave by Type Analysis** - Pie chart breakdown showing distribution across different leave types (Annual, Sick, Casual, etc.)
- **Departmental Leave Overview** - Compare leave utilization across departments

![Leave Insights Dashboard](screenshots/leave-insights-dashboard.jpg)

### Attendance & Timesheet Insights

Monitor attendance patterns, working hours, and project time tracking in a unified dashboard:

- **Attendance Summary** - Track total hours worked, average hours per day
- **Monthly & Weekly Patterns** - Identify attendance trends over time
- **Department-wise Attendance** - Compare attendance across teams
- **Project Time Distribution** - See how time is allocated across projects
- **Employee Time Tracking** - Monitor individual contributor time logs

![Attendance Insights](screenshots/attendance-insights.jpg)

---

## Redesigned Payroll Configuration Module

The new **Payroll Configuration** module provides a complete payroll management solution with flexible configuration options and automated processing.

### Key Features

#### Payroll Column Configuration
- Define custom payroll columns (earnings, deductions, contributions)
- Built-in code editor for calculation functions with syntax validation
- Support for predefined calculation types

![Payroll Column Editor](screenshots/payroll-column-editor.jpg)

#### Payslip Template Designer
- Create custom payslip templates with HTML/CSS
- Preview templates before deployment
- Mark legacy templates for deprecation
- Protection against deleting templates in use

![Payslip Template](screenshots/payslip-template.jpg)

#### Payroll Processing
- Batch process employee payrolls
- View payroll data by employee with profile images
- Generate and manage payslips
- Delete generated payslips when needed
- Multi-currency support

![Payroll Processing](screenshots/payroll-processing.jpg)

#### Employee Payroll Assignments
- Redesigned the UI for assigning employees to different payrolls.
- Ability to run multiple payrolls for different employees.

![Payroll Processing](screenshots/payroll-employees.jpg)

---

## Enhanced Travel Management

The Travel module has been completely rebuilt, offering a modern interface and new capabilities.

### New Travel Request Features

#### Comprehensive Trip Details
- **Trip Classification**: Domestic, International, or Regional travel
- **Detailed Itinerary**: From/To locations with country and city fields

![Travel Request Form](screenshots/travel-request-form.jpg)

#### Booking Information
- Flight/booking confirmation numbers
- Airline and flight number tracking
- Accommodation details

#### Travel Project & Budget Integration
- Link travel requests to travel projects
- Multi-currency budget management
- Attachment support for receipts and documents

#### Step-by-Step Request Form
- Multi-step modal for creating travel requests
- Clear separation of mandatory and optional information
- Location picker with map integration

![Travel Request View](screenshots/travel-request-view.jpg)

---

## Project Time Tracking

Enhanced project management with comprehensive time tracking and team assignment features.

### Project Detail View

A new **Project Detail View** replaces the table with rich project information:

- **Project Summary Statistics**
  - Total hours logged
  - Approved hours vs pending hours
  - Number of team members

![Project Detail View](screenshots/project-detail-view.jpg)

### Time Tracking Charts

- **Time by Employee Chart**: Horizontal grouped bar chart showing total, approved, and pending hours per employee
- **Monthly Time Breakdown**: Track project hours over time with monthly distribution

### Team Management

- **Assigned Employees Panel**: View all employees assigned to a project
- **Add/Remove Employees**: Quickly add or remove team members from projects
- **Employee Status Tracking**: See start dates and current assignment status

---

## Employee Profile Enhancements

### Profile Images Everywhere

Employee profile images are now displayed across all modules for better visual identification:

- Leave request lists
- Attendance records
- Performance reviews
- Training sessions
- Expense reports
- Overtime requests
- Travel requests
- Salary information
- Document lists
- Forms and feedback

### Employee Profile Tabs

New tabs added to the employee profile view:

- **Leave Tab**: View employee's leave history and balances
- **Attendance Tab**: Quick access to attendance records

![Employee Profile Tabs](screenshots/employee-profile-tabs.jpg)

### Resigned Employees

- Renamed "Deactivate" to "Resigned" for clearer terminology
- Added ability to view resigned employees with dedicated filter
- Better handling of employee status transitions

---

## Performance Management Improvements

### Bulk Performance Review Creation

Create performance reviews for multiple employees at once:

- Select multiple employees from a list
- Set common review parameters
- Automatically create individual review records
- Status defaults to "Pending" for new reviews

### Feedback Request Enhancements

- Create feedback requests in bulk
- Feedback requests only available for pending reviews
- Default status set to "Pending" for new feedback requests
- Improved self-feedback UI

---

## Sandwich Leave Support

New **Sandwich Leave** feature for handling leaves that fall between holidays and weekends.

### Configuration

- Mark specific leave types as "Sandwich Leave" using a simple toggle switch
- When enabled, leaves of this type are always counted as full days
- Useful for unpaid leave policies where organizations want to count leaves between non-working days

### How It Works

When an employee takes leave on a Friday and Monday (with Saturday/Sunday in between):
- Regular leave: Only Friday and Monday counted (2 days)
- Sandwich leave: Friday through Monday counted (4 days)

---

## Settings Module Redesign

The Settings module has been completely redesigned for better usability.

### Search Settings

New search functionality allows you to quickly find settings by name or description.

### Organized Display

- Settings are now ordered logically within each category
- Improved setting descriptions
- Hidden deprecated settings
- Tabs only show if they have visible settings

### Visual Improvements

- Switch components for Yes/No settings
- Better form layouts
- Multi-select fields with improved UI
- File upload settings with preview

![Settings Display](screenshots/settings-display.jpg)

---

## UI/UX Improvements

### Modernized Modals

- Replaced browser modals with modern modals
- Consistent modal behavior across the application
- Loading states on save buttons
- Better error handling and display

### Menu Improvements

- Updated menu names for clarity
- Highlighted first-level menus
- Removed animating icons for cleaner look
- Updated icons across modules

### Modernized Modules

The following modules have been modernized for better performance:

- User Leave Module
- Dependent Module
- Emergency Contacts Module
- Qualifications Module
- Travel Module (Admin & User)

### Company Overview Module

New module providing organizational overview and statistics.

![Company Overview](screenshots/company-overview.jpg)

### Advanced Reports Module

Enhanced reporting capabilities with the new Advanced Reports module, replacing the legacy reports system.

![Reports](screenshots/reports.jpg)
---

## Bug Fixes

This release includes numerous bug fixes:

- **Fixed** loading save button in step form modals
- **Fixed** loading button state when entry saving fails
- **Fixed** subordinate travel requests display
- **Fixed** location field in travel user module
- **Fixed** location component layout issues
- **Fixed** double chart rendering in insights
- **Fixed** advance attendance view display
- **Fixed** first profile load issue
- **Fixed** reports module issues
- **Fixed** "switched to" styling issues
- **Fixed** form fields with display:none rendering
- **Improved** cache fallback when memcache is not available

---

## Module Cleanup

As part of ongoing platform improvements, the following legacy modules have been removed:

- Legacy Charts Module (replaced by Insights)
- Legacy Leave Charts Module (replaced by Insights)
- Legacy Data Module
- Legacy Clients Module (merged into Projects)
- Legacy Report Files Module (replaced by Advanced Reports)

---

## Upgrade Notes

### Database Migrations

This release includes migrations for:
- Sandwich leave column on LeaveTypes table
- Settings order and description updates
- Payslip template additions
- Module cleanup

### Breaking Changes

None. All changes are backward compatible.

---

## Coming Soon

Stay tuned for upcoming features:
- Mobile app improvements
- Enhanced API capabilities
- More analytics dashboards
- Workflow automation

