/**
 * https://openmoji.org/
 */
import Icon from '@ant-design/icons';
import React from 'react';

const WonderfulFace = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <path fill="#FFCC4D" d="M36 18c0 9.941-8.059 18-18 18-9.94 0-18-8.059-18-18C0 8.06 8.06 0 18 0c9.941 0 18 8.06 18 18"/><ellipse fill="#664500" cx="11.5" cy="12.5" rx="2.5" ry="5.5"/><ellipse fill="#664500" cx="24.5" cy="12.5" rx="2.5" ry="5.5"/><path fill="#664500" d="M18 22c-3.623 0-6.027-.422-9-1-.679-.131-2 0-2 2 0 4 4.595 9 11 9 6.404 0 11-5 11-9 0-2-1.321-2.132-2-2-2.973.578-5.377 1-9 1z"/><path fill="#FFF" d="M9 23s3 1 9 1 9-1 9-1-2 4-9 4-9-4-9-4z"/>
  </svg>
);

const WonderfulFaceIcon = (props) => <Icon component={WonderfulFace} {...props} />;

const HappyFace = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <circle fill="#FFCC4D" cx="18" cy="18" r="18"/><path fill="#664500" d="M10.515 23.621C10.56 23.8 11.683 28 18 28c6.318 0 7.44-4.2 7.485-4.379.055-.217-.043-.442-.237-.554-.195-.111-.439-.078-.6.077C24.629 23.163 22.694 25 18 25s-6.63-1.837-6.648-1.855C11.256 23.05 11.128 23 11 23c-.084 0-.169.021-.246.064-.196.112-.294.339-.239.557z"/><ellipse fill="#664500" cx="12" cy="13.5" rx="2.5" ry="3.5"/><ellipse fill="#664500" cx="24" cy="13.5" rx="2.5" ry="3.5"/>
  </svg>
);

const HappyFaceIcon = (props) => <Icon component={HappyFace} {...props} />;

const NeutralFace = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <path fill="#FFCC4D" d="M36 18c0 9.941-8.059 18-18 18-9.94 0-18-8.059-18-18C0 8.06 8.06 0 18 0c9.941 0 18 8.06 18 18"/><ellipse fill="#664500" cx="11.5" cy="16.5" rx="2.5" ry="3.5"/><ellipse fill="#664500" cx="24.5" cy="16.5" rx="2.5" ry="3.5"/><path fill="#664500" d="M25 26H11c-.552 0-1-.447-1-1s.448-1 1-1h14c.553 0 1 .447 1 1s-.447 1-1 1z"/>
  </svg>
);

const NeutralFaceIcon = (props) => <Icon component={NeutralFace} {...props} />;

const SadFace = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <circle fill="#FFCC4D" cx="18" cy="18" r="18"/><path fill="#664500" d="M25.485 27.379C25.44 27.2 24.317 23 18 23c-6.318 0-7.44 4.2-7.485 4.379-.055.217.043.442.237.554.195.111.439.078.6-.077C11.371 27.837 13.306 26 18 26s6.63 1.837 6.648 1.855c.096.095.224.145.352.145.084 0 .169-.021.246-.064.196-.112.294-.339.239-.557z"/><ellipse fill="#664500" cx="12" cy="13.5" rx="2.5" ry="3.5"/><ellipse fill="#664500" cx="24" cy="13.5" rx="2.5" ry="3.5"/>
  </svg>
);

const SadFaceIcon = (props) => <Icon component={SadFace} {...props} />;

const SleepyFace = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <circle fill="#FFCC4D" cx="18" cy="18" r="18"/><circle fill="#664500" cx="18" cy="26" r="3"/><path fill="#664500" d="M17.312 16.612c-.176-.143-.427-.147-.61-.014-.012.009-1.26.902-3.702.902-2.441 0-3.69-.893-3.7-.9-.183-.137-.435-.133-.611.009-.178.142-.238.386-.146.594.06.135 1.5 3.297 4.457 3.297 2.958 0 4.397-3.162 4.457-3.297.092-.207.032-.449-.145-.591zm10 0c-.176-.143-.426-.148-.61-.014-.012.009-1.261.902-3.702.902-2.44 0-3.69-.893-3.7-.9-.183-.137-.434-.133-.611.009-.178.142-.238.386-.146.594.06.135 1.5 3.297 4.457 3.297 2.958 0 4.397-3.162 4.457-3.297.092-.207.032-.449-.145-.591z"/><path fill="#FFAC33" d="M34.43 12.534c.004-.044.023-.077.023-.123 0-.754-.548-1.188-1.225-1.188h-3.582l4.279-5.993c.206-.283.282-.453.282-.811 0-.735-.64-.849-.885-.849h-5.349l-.032-.688s-1.409.831-1.503.888-.505.372-.505.987c0 .754.546 1.187 1.225 1.187h3.149l-4.261 5.993c-.094.151-.244.433-.244.735 0 .622.508.924 1.111.924h6.315c.258 0 .515-.076.681-.176l1.503-.888h-.982z"/><path fill="#2A6797" d="M31.771 5.084h-3.149c-.679 0-1.225-.433-1.225-1.187s.546-1.188 1.225-1.188h6.164c.245 0 .885.113.885.848 0 .358-.076.528-.282.811l-4.279 5.993h3.582c.677 0 1.225.433 1.225 1.187s-.548 1.187-1.225 1.187h-6.315c-.603 0-1.111-.302-1.111-.924 0-.302.15-.584.244-.735l4.261-5.992z"/><path fill="#FFAC33" d="M24.886 7.48c.003-.033.018-.058.018-.092 0-.564-.41-.889-.917-.889h-2.682l3.203-4.487c.156-.212.212-.339.212-.606 0-.55-.479-.635-.663-.635h-4.004l-.024-.515s-1.055.622-1.125.665c-.07.043-.378.279-.378.739 0 .564.409.889.917.889H21.8l-3.19 4.487c-.07.113-.183.324-.183.55 0 .466.38.691.832.691h4.728c.193 0 .385-.057.51-.132l1.125-.665h-.736z"/><path fill="#2A6797" d="M22.896 1.903h-2.357c-.508 0-.917-.324-.917-.889 0-.564.409-.889.917-.889h4.615c.184 0 .663.085.663.635 0 .268-.057.395-.211.607l-3.203 4.487h2.682c.505 0 .915.324.915.889s-.41.889-.917.889h-4.728c-.452 0-.832-.226-.832-.691 0-.226.113-.437.183-.55l3.19-4.488z"/><path fill="#FFAC33" d="M17.741 10.425c.003-.028.015-.049.015-.079 0-.483-.351-.761-.785-.761h-2.295l2.742-3.84c.132-.181.181-.29.181-.519 0-.471-.41-.544-.567-.544h-3.427l-.021-.441-.963.569c-.06.037-.324.238-.324.633 0 .483.35.761.785.761h2.017l-2.73 3.84c-.06.097-.157.278-.157.471 0 .399.326.592.712.592h4.047c.165 0 .33-.049.436-.113l.963-.569h-.629z"/><path fill="#2A6797" d="M16.037 5.652H14.02c-.435 0-.785-.278-.785-.761s.35-.761.785-.761h3.95c.157 0 .567.073.567.544 0 .229-.048.338-.181.519l-2.742 3.84h2.295c.434 0 .785.278.785.761s-.351.761-.785.761h-4.047c-.386 0-.712-.193-.712-.592 0-.193.096-.374.157-.471l2.73-3.84z"/>
  </svg>
);

const SleepyFaceIcon = (props) => <Icon component={SleepyFace} {...props} />;

const ExhaustedFace = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <path fill="#FFCC4D" d="M36 18c0 9.941-8.059 18-18 18-9.94 0-18-8.059-18-18C0 8.06 8.06 0 18 0c9.941 0 18 8.06 18 18"/><path fill="#664500" d="M6 13c-.552 0-1-.448-1-1 0-.551.445-.998.996-1 .156-.002 3.569-.086 6.205-3.6.331-.44.957-.532 1.4-.2.442.331.531.958.2 1.4C10.538 12.95 6.184 13 6 13zm24 0c-.184 0-4.537-.05-7.8-4.4-.332-.442-.242-1.069.2-1.4.441-.333 1.067-.242 1.399.2 2.641 3.521 6.061 3.599 6.206 3.6.55.006.994.456.991 1.005-.002.551-.446.995-.996.995zM6.001 22c-.304 0-.604-.138-.801-.4-.332-.441-.242-1.068.2-1.399.143-.107 2.951-2.183 6.856-2.933C9.781 16.027 7.034 16 6.999 16c-.552-.002-.999-.45-.998-1.002 0-.551.447-.998.999-.998.221 0 5.452.038 8.707 3.293.286.286.372.716.217 1.09-.155.374-.52.617-.924.617-4.613 0-8.363 2.772-8.4 2.8-.18.135-.391.2-.599.2zm23.998-.001c-.208 0-.418-.064-.598-.198C29.363 21.772 25.59 19 21 19c-.404 0-.77-.243-.924-.617-.155-.374-.069-.804.217-1.09C23.549 14.038 28.779 14 29 14c.552 0 .998.447.999.998.001.552-.446 1-.997 1.002-.036 0-2.783.027-5.258 1.268 3.905.75 6.713 2.825 6.855 2.933.441.331.531.956.201 1.398-.196.261-.496.4-.801.4zM18 30c-.304 0-.591-.138-.781-.375l-3.194-3.992L11.8 28.6c-.174.232-.44.377-.729.397-.29.021-.574-.085-.778-.29l-1-1c-.391-.391-.391-1.023 0-1.414s1.023-.391 1.414 0l.185.185L13.2 23.4c.186-.248.475-.396.784-.4.295-.01.603.133.796.375L18 27.399l3.219-4.024c.193-.241.484-.375.797-.375.31.005.599.152.784.4l2.309 3.077.185-.185c.391-.391 1.023-.391 1.414 0s.391 1.023 0 1.414l-1 1c-.205.205-.479.314-.778.29-.289-.021-.555-.165-.729-.397l-2.226-2.967-3.193 3.992c-.191.238-.478.376-.782.376z"/>
  </svg>
);

const ExhaustedFaceIcon = (props) => <Icon component={ExhaustedFace} {...props} />;

const Motivated = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <path fill="#EF9645" d="M15.977 9.36h3.789c.114-.191.147-.439.058-.673l-3.846-4.705V9.36z"/><path fill="#FFDC5D" d="M12.804 22.277c-.057-.349-.124-.679-.206-.973-.62-2.223-1.14-3.164-.918-5.494.29-1.584.273-4.763 4.483-4.268 1.112.131 2.843.927 3.834.91.567-.01.98-1.157 1.017-1.539.051-.526-.865-1.42-1.248-1.554-.383-.134-2.012-.631-2.681-.824-1.039-.301-.985-1.705-1.051-2.205-.031-.235.084-.467.294-.591.21-.124.375-.008.579.125l.885.648c.497.426-.874 1.24-.503 1.376 0 0 1.755.659 2.507.796.412.075 1.834-1.529 1.917-2.47.065-.74-3.398-4.083-5.867-5.381-.868-.456-1.377-.721-1.949-.694-.683.032-.898.302-1.748 1.03C8.302 4.46 4.568 11.577 4.02 13.152c-2.246 6.461-2.597 9.865-2.677 11.788-.049.59-.076 1.177-.076 1.758.065 0-1 5 0 6s5.326 1 5.326 1c10 3.989 28.57 2.948 28.57-7.233 0-12.172-18.813-10.557-22.359-4.188z"/><path fill="#EF9645" d="M20.63 32.078c-3.16-.332-5.628-1.881-5.767-1.97-.465-.297-.601-.913-.305-1.379s.913-.603 1.38-.308c.04.025 4.003 2.492 7.846 1.467 2.125-.566 3.867-2.115 5.177-4.601.258-.49.866-.676 1.351-.419.488.257.676.862.419 1.351-1.585 3.006-3.754 4.893-6.447 5.606-1.257.332-2.502.374-3.654.253z"/>
  </svg>
);

const MotivatedIcon = (props) => <Icon component={Motivated} {...props} />;

const DoNotDisturb = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <path fill="#BE1931" d="M36 18c0 9.941-8.059 18-18 18S0 27.941 0 18 8.059 0 18 0s18 8.059 18 18z"/><path fill="#FFF" d="M32 20c0 1.104-.896 2-2 2H6c-1.104 0-2-.896-2-2v-4c0-1.104.896-2 2-2h24c1.104 0 2 .896 2 2v4z"/>
  </svg>
);

const DoNotDisturbIcon = (props) => <Icon component={DoNotDisturb} {...props} />;

const Busy = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <path fill="#292F33" d="M16 5h4v3h-4z"/><path fill="#8899A6" d="M22 1h-8c-1.1 0-2 .9-2 2s.9 2 2 2h8c1.1 0 2-.9 2-2s-.9-2-2-2zm6.184 10.507l-1.504-1.318c-.827-.725-.911-1.995-.186-2.822.725-.827 1.995-.911 2.822-.186l1.504 1.318c.827.725.911 1.995.186 2.822-.725.827-1.995.911-2.822.186z"/><circle fill="#F5F8FA" cx="18" cy="21" r="11"/><path fill="#66757F" d="M18 7C10.268 7 4 13.268 4 21s6.268 14 14 14 14-6.268 14-14S25.732 7 18 7zm0 25c-6.065 0-11-4.935-11-11s4.935-11 11-11 11 4.935 11 11-4.935 11-11 11z"/><path fill="#292F33" d="M27 22H17c-.552 0-1-.447-1-1s.448-1 1-1h10c.553 0 1 .447 1 1s-.447 1-1 1z"/><circle fill="#292F33" cx="18" cy="12" r="1"/><circle fill="#292F33" cx="18" cy="30" r="1"/><circle fill="#292F33" cx="12" cy="15" r="1"/><circle fill="#292F33" cx="24" cy="27" r="1"/><circle fill="#292F33" cx="9" cy="21" r="1"/><circle fill="#292F33" cx="24" cy="15" r="1"/><path fill="#DD2E44" d="M12 28c-.256 0-.512-.098-.707-.293-.391-.391-.391-1.023 0-1.414l7-7c.391-.391 1.023-.391 1.414 0s.391 1.023 0 1.414l-7 7c-.195.195-.451.293-.707.293z"/>
  </svg>
);

const BusyIcon = (props) => <Icon component={Busy} {...props} />;

const OutForLunch = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <path fill="#99AAB5" d="M19 1.5c0-.829-.672-1.5-1.5-1.5-.829 0-1.5.671-1.5 1.5V11c0 .552-.448 1-1 1s-1-.448-1-1V1.5c0-.829-.671-1.5-1.5-1.5S11 .671 11 1.5V11c0 .552-.448 1-1 1s-1-.448-1-1V1.5C9 .671 8.329 0 7.5 0S6 .671 6 1.5v9c0 .127.021.249.051.367-.03.207-.051.417-.051.633 0 2.316 1.75 5.957 4 6.442V33.5c0 1.381 1.119 2.5 2.5 2.5s2.5-1.119 2.5-2.5V17.942c2.25-.485 4-4.126 4-6.442 0-.216-.021-.426-.051-.633.03-.118.051-.24.051-.367v-9zM27.5 0c-.104 0-.204.019-.306.031C27.13.021 27.067 0 27 0c-2.209 0-5 5.477-5 11 0 4.658 1.275 8.56 3 9.672V33.5c0 1.381 1.119 2.5 2.5 2.5s2.5-1.119 2.5-2.5v-31C30 1.119 28.881 0 27.5 0z"/>
  </svg>
);

const OutForLunchIcon = (props) => <Icon component={OutForLunch} {...props} />;

const Away = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <circle fill="#F4900C" cx="18" cy="18" r="18"/>
  </svg>
);

const AwayIcon = (props) => <Icon component={Away} {...props} />;

const Available = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <circle fill="#78B159" cx="18" cy="18" r="18"/>
  </svg>
);

const AvailableIcon = (props) => <Icon component={Available} {...props} />;

const Meeting = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <path fill="#BE1931" d="M36 11.5C36 8.462 33 4 18 4S0 8.462 0 11.5c0 .045.019.076.022.119-.012.196-.022.402-.022.631C0 14.873 2.239 16 5 16s5-1.127 5-3.75c0-.218-.021-.412-.051-.597C12.374 11.302 15.102 11 18 11s5.626.302 8.051.653c-.03.185-.051.379-.051.597 0 2.623 2.238 3.75 5 3.75s5-1.127 5-3.75c0-.225-.009-.429-.024-.621.004-.046.024-.08.024-.129z"/><path fill="#DD2E44" d="M34.934 23c-.482-1.031-2.31-4.19-3.968-7.007C29.408 13.346 27 11 25 11V9c0-1.104-.896-2-2-2s-2 .896-2 2v2h-6V9c0-1.104-.896-2-2-2s-2 .896-2 2v2c-2 0-4.41 2.351-5.97 5-1.657 2.815-3.483 5.97-3.964 7C.488 24.239 0 25 0 27s1.791 5 4 5h28c2.209 0 4-3 4-5s-.448-2.676-1.066-4z"/><path fill="#FFF" d="M20.046 14.818c0 .452-.916.818-2.046.818s-2.045-.366-2.045-.818c0-.452.915-.818 2.045-.818s2.046.366 2.046.818zm-4.91 0c0 .452-.915.818-2.045.818s-2.045-.366-2.045-.818c0-.452.916-.818 2.045-.818s2.045.366 2.045.818zm9.818 0c0 .452-.915.818-2.045.818s-2.046-.366-2.046-.818c0-.452.916-.818 2.046-.818s2.045.366 2.045.818zm-4.5 2.864c0 .679-1.099 1.228-2.454 1.228s-2.455-.549-2.455-1.228c0-.677 1.099-1.227 2.455-1.227s2.454.549 2.454 1.227zm5.728 0c0 .679-1.1 1.228-2.454 1.228-1.355 0-2.455-.549-2.455-1.228 0-.677 1.1-1.227 2.455-1.227 1.354 0 2.454.549 2.454 1.227zm-11.455 0c0 .679-1.099 1.228-2.454 1.228-1.355 0-2.455-.549-2.455-1.228 0-.677 1.099-1.227 2.455-1.227 1.355 0 2.454.549 2.454 1.227zm6.545 3.681C21.272 22.269 19.807 23 18 23c-1.807 0-3.273-.731-3.273-1.637 0-.903 1.466-1.636 3.273-1.636 1.807.001 3.272.733 3.272 1.636zm7.365 0c0 .905-1.467 1.637-3.273 1.637-1.807 0-3.273-.731-3.273-1.637 0-.903 1.466-1.636 3.273-1.636 1.806.001 3.273.733 3.273 1.636zm-14.728 0c0 .905-1.466 1.637-3.273 1.637-1.807 0-3.272-.731-3.272-1.637 0-.903 1.465-1.636 3.272-1.636 1.807.001 3.273.733 3.273 1.636z"/>
  </svg>
);

const MeetingIcon = (props) => <Icon component={Meeting} {...props} />;

const NotSet = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <circle fill="#31373D" cx="18" cy="18" r="18"/>
  </svg>
);

const NotSetIcon = (props) => <Icon component={NotSet} {...props} />;

const Sick = () => (
  <svg width="1em" height="1em" fill="currentColor" viewBox="0 0 36 36">
    <path fill="#FFCC4D" d="M36 18c0 9.941-8.059 18-18 18-9.94 0-18-8.059-18-18C0 8.06 8.06 0 18 0c9.941 0 18 8.06 18 18"/><path fill="#664500" d="M7.001 15c-.323 0-.64-.156-.833-.445-.306-.46-.182-1.081.277-1.387C6.578 13.08 9.746 11 14 11c.552 0 1 .448 1 1s-.448 1-1 1c-3.655 0-6.418 1.814-6.445 1.832-.171.114-.364.168-.554.168zm21.998 0c-.189 0-.382-.054-.552-.167C28.419 14.815 25.628 13 22 13c-.553 0-1-.448-1-1s.447-1 1-1c4.254 0 7.422 2.08 7.555 2.168.46.306.584.927.277 1.387-.192.289-.51.445-.833.445z"/><path fill="#F5F8FA" d="M27 22.091L36 18c0-.66-.041-1.309-.109-1.95L27 20.091V19c0-1.104-.896-2-2-2H11c-1.104 0-2 .896-2 2v1.091L.11 16.05C.041 16.691 0 17.34 0 18l9 4.091v4.546l-7.453-1.355c.341.77.741 1.507 1.183 2.215L9 28.637V30c0 1.104.896 2 2 2h14c1.104 0 2-.896 2-2v-1.363l6.271-1.141c.441-.708.841-1.445 1.182-2.215L27 26.637v-4.546z"/>
  </svg>
);

const SickIcon = (props) => <Icon component={Sick} {...props} />;


module.exports = {
  WonderfulFaceIcon,
  HappyFaceIcon,
  NeutralFaceIcon,
  SadFaceIcon,
  SleepyFaceIcon,
  ExhaustedFaceIcon,
  MotivatedIcon,
  DoNotDisturbIcon,
  BusyIcon,
  OutForLunchIcon,
  AwayIcon,
  MeetingIcon,
  AvailableIcon,
  NotSetIcon,
  SickIcon,
};
